//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.9 Page 508
//Title: Calculate the composition and temperature of SO3 product stream
//==================================================================================
model Ex13_9

//==================================
//Parameter section
parameter Real T0(unit="K")=298.15 "Temperature of reaction";
parameter Real P(unit="bar")=1 "Pressure of reaction";
parameter Real deltaH_298(unit="J/mol")=-98890 "Enthalpy change of reaction";
parameter Real deltaG_298(unit="J/mol")=-70866 "Free energy change of reaction";
parameter Real excess(unit="%")=20 "% of excess air";
parameter Real R(unit="J/ mol K")=8.314 "Univeral gas constant";

//==================================
//Variable section
Real O2_enter(unit="mol") "No. of moles of O2 entering";
Real N2_enter(unit="mol") "No. of moles of N2 entering";
Real n_N2(unit="mol") "No. of moles of N2";
Real n_SO2(unit="mol") "No. of moles of SO2";
Real n_SO3(unit="mol") "No. of moles of SO3";
Real n_O2(unit="mol") "No. of moles of O2";
Real y_N2(unit="mol") "Mole fraction of N2";
Real y_SO2(unit="mol") "Mole fraction of SO2";
Real y_SO3(unit="mol") "Mole fraction of SO3";
Real y_O2(unit="mol") "Mole fraction of O2";
Real eps(unit="mol") "No. of moles reacted";
Real tau(unit="") "Ratio of temperature";
Real T1(start=298.15) "Temperature of leaving stream";
Real[4] Cp_H(unit="J/mol K") "Specific heats of components";
Real Cp_H0(unit="J/mol K") "Specific heats of product stream";
Real K(unit="") "Equilibrium constant";
Real IDCPH(unit="") "Integral function";
Real IDCPS(unit="") "Integral function";

//==================================
//Equation section
equation
O2_enter = 0.5*(1+excess/100);
N2_enter = O2_enter*(79/21);
tau = T1/T0;
Cp_H[1] = R*(5.699+0.801e-3*T0/2*(tau+1)+0/3*T0^2*(tau^2+tau+1)-1.015e5/(tau*T0^2));
Cp_H[2] = R*(3.639+0.506e-3*T0/2*(tau+1)+0/3*T0^2*(tau^2+tau+1)-0.227e5/(tau*T0^2));
Cp_H[3] = R*(8.060+1.056e-3*T0/2*(tau+1)+0/3*01^2*(tau^2+tau+1)-2.028e5/(tau*T0^2));
Cp_H[4] = R*(3.280+0.593e-3*T0/2*(tau+1)+0/3*T0^2*(tau^2+tau+1)+0.04e5/(tau*T0^2));
n_SO2 = 1-eps;
n_O2 = O2_enter-0.5*eps;
n_SO3 =eps;
n_N2 = N2_enter;
Cp_H0 = n_SO2*Cp_H[1]+n_O2*Cp_H[2]+n_SO3*Cp_H[3]+n_N2*Cp_H[4];
deltaH_298*eps +  Cp_H0*(T1-T0) = 0;
K = eps/(1-eps)*((n_SO2+n_O2+n_SO3+n_N2)/(n_O2))^0.5;
-log(K) = (deltaG_298-deltaH_298)/(R*T0)+deltaH_298/(R*T1)+IDCPH/T1-IDCPS;
IDCPS = 0.5415*log(tau)+(0.002e-3*T0+(0*T0^2-0.8665e5/T1^2)*((tau+1)/2))*(tau-1);
IDCPH = (0.5415+0.002e-3*T0/2*(tau+1)+0/3*T0^2*(tau^2+tau+1)-0.8995e5/(tau*T0^2))*(T1-T0);
y_SO2 = n_SO2/(n_SO2+n_O2+n_SO3+n_N2);
y_O2 = n_O2/(n_SO2+n_O2+n_SO3+n_N2);
y_SO3 =n_SO3/(n_SO2+n_O2+n_SO3+n_N2);
y_N2 = n_N2/(n_SO2+n_O2+n_SO3+n_N2);

end Ex13_9;
//==================================================================================