//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.15 Page 53
//Title: Calculate enthalpy of steam 
//==================================================================================
model Ex2_15

//==================================
//Parameter section
parameter Real mdot(unit = "g/s") =4.15 "Flow rate of water";
parameter Real T1(unit = "K") = 273.15 "Initial temperature";
parameter Real T2(unit = "K") = 573.15 "Final temperature";
parameter Real rate(unit = "W") = 12740 "Rate of heta addition from resistance heater";
 
//==================================
//Variable section
Real H2(unit = "J/g") "Enthalpy of steam at T2 if H1 at T1=0";

//==================================
//Equation section
equation
H2 = rate/mdot;

end Ex2_15;
//==================================================================================