//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.16 Page 54
//Title: Calculate heat to be removed during compression 
//==================================================================================
model Ex2_16

//==================================
//Parameter section
parameter Real P1(unit = "bar")=1 "Initial pressure";
parameter Real P2(unit = "bar")=3 "Final pressure";
parameter Real u2(unit = "m/s")=600 "Final velocity";
parameter Real Ws(unit = "kJ/kg")=240 "Work of compression";

//==================================
//Variable section
Real Q(unit = "kJ/kg") "Heat change during compression";

//==================================
//Equation section
equation
Q = ((u2^2/2)*0.001-Ws); //multiplied by 0.001 to convert J to kJ

end Ex2_16;
//==================================================================================