//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.8 Page 39
//Title: Find change in enthalpy and internal energy 
//==================================================================================
model Ex2_8

//==================================
//Parameter section
parameter Real V1(unit = "m3/kg") =0.00104 "Specific volume of liquid";
parameter Real V2(unit = "m3/kg") =1.673 "Specific volume of vapor";
parameter Real P(unit = "kPa") =101.325 "Pressure of system";
parameter Real Q(unit = "kJ") =2256.9 "Heat added to water";
parameter Real m(unit = "kg") =1 "Mass of water";

//==================================
//Variable section
Real deltaH(unit = "kJ") "Enthalpy of system";
Real deltaU(unit = "kJ") "Internal energy of system";

//==================================
//Equation section
equation
deltaH = Q; 
deltaU = deltaH - P*(V2-V1)*m;//definition of enthalpy

end Ex2_8;
//==================================================================================