package Ex2_9

//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-2:The First Law and Other Basic Concepts
  //Example: 2.9 Page 41
  //Title: Calculate heat and work requirements
  //==================================================================================

  model Ex2_9_a

//==================================
//Parameter section
parameter Real V1(unit = "m3/mole") = 0.02479 "Initial molar volume of air";
parameter Real P1(unit = "bar") = 1 "Initial pressure of air";
parameter Real P2(unit = "bar") = 5 "Final pressure of air";
parameter Real T1(unit = "K") = 298.15 "Initial temperature of air";
parameter Real Cv(unit = "") = 20.78 "Heat capacity at constant volume of air";
parameter Real Cp(unit = "J/(mol K)") = 29.10 "Heat capacity at constant pressure of air";

//==================================
//Variable section
Real V2(unit = "m3") "Final volume of air";
Real T2(unit = "K") "Final temperature of air";
Real Q1(unit = "kJ") "Heat liberated in step 1";
Real Q2(unit = "kJ") "Heat liberated in step 2";
Real deltaH1(unit = "kJ") "Enthalpy change in step 1"; 
Real deltaU1(unit = "kJ") "Internal energy change in step 1"; 
Real deltaU2(unit = "kJ") "Internal energy change in step 2";
Real deltaH(unit = "kJ") "Overall enthalpy change"; 
Real deltaU(unit = "kJ") "Overall internal energy change";
Real Q(unit = "kJ") "Heat liberated";
Real W(unit = "kJ") "Work done";

//==================================
//Equation section
equation
V2 = V1*P1/P2;
T2 = T1*V2/V1;
deltaH1 = Cp*(T2-T1);
Q1 = deltaH1;
deltaU1 = deltaH1-P1*10^5*(V2-V1);
deltaU2 = Cv*(T1-T2);
Q2 = deltaU2;
Q = Q1+Q2;
deltaH = 0;
deltaU = 0;
deltaU = Q+W;

end Ex2_9_a;
//==================================
model Ex2_9_b


//==================================
//Parameter section
parameter Real V1(unit = "m3/mole") = 0.02479 "Initial molar volume of air";
parameter Real P1(unit = "bar") = 1 "Initial pressure of air";
parameter Real P2(unit = "bar") = 5 "Final pressure of air";
parameter Real T1(unit = "K") = 298.15 "Initial temperature of air";
parameter Real Cv(unit = "") = 20.78 "Heat capacity at constant volume of air";
parameter Real Cp(unit = "J/(mol K)") = 29.10 "Heat capacity at constant pressure of air";

//==================================
//Variable section
Real V2(unit = "m3") "Final volume of air";
Real T2(unit = "K") "Final temperature of air";
Real Q1(unit = "kJ") "Heat liberated in step 1";
Real Q2(unit = "kJ") "Heat liberated in step 2";
Real deltaH2(unit = "kJ") "Enthalpy change in step 2";
Real deltaU1(unit = "kJ") "Internal energy change in step 1"; 
Real deltaU2(unit = "kJ") "Internal energy change in step 2";
Real deltaH(unit = "kJ") "Overall enthalpy change"; 
Real deltaU(unit = "kJ") "Overall internal energy change";
Real Q(unit = "kJ") "Heat liberated";
Real W(unit = "kJ") "Work done";

//==================================
//Equation section
equation
V2 = V1*P1/P2;
T2 = T1*P2/P1;
deltaU1 = Cv*(T2-T1);
Q1 = deltaU1;
deltaH2 = Cp*(T1-T2);
deltaU2 = deltaH2-P2*10^5*(V2-V1);
Q2 = deltaH2;
Q = Q1+Q2;
deltaH = 0;
deltaU = 0;
deltaU = Q+W;

end Ex2_9_b;
end Ex2_9;
