package Ex3_11

//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-3:Volumetric properties of pure fluids
  //Example: 3.11 Page 106
  //Title: Pressure of methane calculation
  //==================================================================================

  model Ex3_11_a

//==================================
//Parameter section
parameter Real V(unit = "m^3") =0.125 "Volume of system";
parameter Real T(unit = "K") =323.15  "Temperature of system";
parameter Real R(unit = "m^3 bar/(kmol K)") =0.08314 "Universal gas constant";

//==================================
//Variable section
Real Pa(unit = "bar") "Pressure for a";

//==================================
//Equation section
equation
Pa = R*T/V;

end Ex3_11_a;
//==================================

model Ex3_11_b

//==================================
//Parameter section
parameter Real V(unit = "m^3") =0.125 "Volume of system";
parameter Real T(unit = "K") =323.15  "Temperature of system";
parameter Real omega(unit = "") =0.08664 "RK parameters";
parameter Real Pcr(unit = "bar") =45.99 "Critical pressure of system"; //from appendix B
parameter Real Tc(unit = "K") =190.6  "Critical temperature of system";
parameter Real R(unit = "m^3 bar/(kmol K)") =0.08314 "Universal gas constant";
parameter Real si(unit = "") =0.42748 "RK parameters";  //from Table 3.1

//==================================
//Variable section
Real Tr(unit = "") "Reduced temperature";
Real P(unit = "bar") "Pressure for b";
Real a(unit = "") "RK parameters"; 
Real b(unit = "") "RK parameters";

//==================================
//Equation section
equation
Tr = T/Tc;
a = si*Tr^(-0.5)*R^2*Tc^2/Pcr;
b = omega*R*Tc/Pcr;
P = R*T/(V-b)-a/(V*(V+b));

end Ex3_11_b;
//==================================

model Ex3_11_c

//==================================
//Parameter section
parameter Real V(unit = "m^3") =0.125 "Volume of system";
parameter Real T(unit = "K") =323.15  "Temperature of system";
parameter Real omega(unit = "") =0.012 "RK parameters";
parameter Real R(unit = "m^3 bar/(kmol K)") =0.08314 "Universal gas constant";

//==================================
//Variable section
Real Z(unit = "") "Compressibility factor for c";
Real Z0(unit = "") "From interpolation in tables E.1 and E.2";
Real Z1(unit = "") "From interpolation in tables E.1 and E.2";
Real P(unit = "bar") "Pressure for c";

//==================================
//Equation section
equation
Z0 =0.887; // from table E.3 and E.4
Z1 =0.258; // from table E.3 and E.4
Z = Z0+(omega*Z1);
P = Z*R*T/V;

end Ex3_11_c;
//==================================
end Ex3_11;
