package Ex3_12
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-3:Volumetric properties of pure fluids
  //Example: 3.12 Page 108
  //Title: Pressure of gaseous ammonia
  //==================================================================================

  model Ex3_12_a
    //==================================
    //Parameter section
    parameter Real Vt(unit = "cm^3") = 30000 "Volume of system";
    parameter Real T(unit = "K") = 338.15 "Temperature of system";
    parameter Real M(unit = "g/mol") = 17.02 "Molecular weight of ammonia";
    parameter Real m(unit = "g") = 500 "Mass of ammonia";
    parameter Real Pc(unit = "bar") = 112.8 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 405.7 "Critical temperature of system";
    parameter Real omega(unit = "") = 0.253 "Pitzer parameters";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real V(unit = "cm^3/mol") "Molar volume";
    Real Pa(unit = "bar") "Pressure for a";
    //==================================
    //Equation section
  equation
    V = Vt / (m / M);
//convert volume to molar volume
    Pa = R * T / V;
  end Ex3_12_a;

  //==================================

  model Ex3_12_b
    //==================================
    //Parameter section
    parameter Real Vt(unit = "cm^3") = 30000 "Volume of system";
    parameter Real T(unit = "K") = 338.15 "Temperature of system";
    parameter Real M(unit = "g/mol") = 17.02 "Molecular weight of ammonia";
    parameter Real m(unit = "g") = 500 "Mass of ammonia";
    parameter Real Pc(unit = "bar") = 112.8 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 405.7 "Critical temperature of system";
    parameter Real omega(unit = "") = 0.253 "Pitzer parameters";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real V(unit = "cm^3/mol") "Molar volume";
    Real Pb(unit = "bar") "Pressure for b";
    Real B0(unit = "") "Virial parameter";
    Real B1(unit = "") "Virial parameter";
    Real Bcap(unit = "") "Virial parameter";
    Real B(unit = "") "Virial parameter";
    Real Tr(unit = "") "Reduced temperature";
  
    //==================================
    //Equation section
  equation
    V = Vt / (m / M);
//convert volume to molar volume
    Tr = T / Tc;
    B0 = 0.083 - 0.422 / Tr ^ 1.6;
//from equation 3.65
    B1 = 0.139 - 0.172 / Tr ^ 4.2;
//from equation 3.66
    Bcap = B0 + omega * B1;
    B = Bcap * R * Tc / Pc;
    Pb = R * T / (V - B);
  end Ex3_12_b;

  //==================================
end Ex3_12;
