package Ex3_2
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-3:Volumetric properties of pure fluids
  //Example: 3.2 Page 80
  //Title: Calculate energy change in 3 different reversible processes
  //==================================================================================

  model Ex3_2_a
    //==================================
    //Parameter section
    parameter Real P1(unit = "bar") = 1 "Initial pressure of system";
    parameter Real P2(unit = "bar") = 5 "Final pressure of system";
    parameter Real T1(unit = "K") = 298.15 "Initial temperature of system";
    parameter Real R(unit = "J/(mol K)") = 8.314 "Universal gas constant";
    //==================================
    //Variable section
    Real cp(unit = "J/(mol K)") "Constant pressure heat capacity";
    Real cv(unit = "") "Constant volume heat capacity";
    Real Tdash(unit = "K") "Final adiabatic temperature of system";
    Real Q(unit = "J") "Heat transferred in a";
    Real W(unit = "J") "Work required in a";
    Real deltaU(unit = "J") "Change in internal energy in a";
    Real deltaH(unit = "J") "Change in enthalpy in a";
    //==================================
    //Equation section
  equation
    cp = 7 / 2 * R;
    cv = 5 / 2 * R;
    deltaU = 0;
//constant temperature at beginning and end
    deltaH = 0;
    Tdash = T1 * (P2 / P1);
    Q = cv * (Tdash - T1) + cp * (T1 - Tdash);
    W = -Q;
  end Ex3_2_a;

  //==================================

  model Ex3_2_b
    //==================================
    //Parameter section
    parameter Real P1(unit = "bar") = 1 "Initial pressure of system";
    parameter Real P2(unit = "bar") = 5 "Final pressure of system";
    parameter Real T1(unit = "K") = 298.15 "Initial temperature of system";
    parameter Real R(unit = "J/(mol K)") = 8.314 "Universal gas constant";
    //==================================
    //Variable section
    Real cp(unit = "J/(mol K)") "Constant pressure heat capacity";
    Real cv(unit = "") "Constant volume heat capacity";
    Real Q(unit = "J") "Heat transferred in b";
    Real W(unit = "J") "Work required in b";
    Real deltaU(unit = "J") "Change in internal energy in b";
    Real deltaH(unit = "J") "Change in enthalpy in b";
    //==================================
    //Equation section
  equation
    cp = 7 / 2 * R;
    cv = 5 / 2 * R;
    deltaU = 0;
//constant temperature at beginning and end
    deltaH = 0;
    Q = R * T1 * log(P1 / P2);
    W = -Q;
  end Ex3_2_b;

  //==================================

  model Ex3_2_c
    //==================================
    //Parameter section
    parameter Real P1(unit = "bar") = 1 "Initial pressure of system";
    parameter Real P2(unit = "bar") = 5 "Final pressure of system";
    parameter Real T1(unit = "K") = 298.15 "Initial temperature of system";
    parameter Real R(unit = "J/(mol K)") = 8.314 "Universal gas constant";
    //==================================
    //Variable section
    Real cp(unit = "J/(mol K)") "Constant pressure heat capacity";
    Real cv(unit = "") "Constant volume heat capacity";
    Real Q(unit = "J") "Heat transferred in c";
    Real W(unit = "J") "Work required in c";
    Real deltaU(unit = "J") "Change in internal energy in c";
    Real deltaH(unit = "J") "Change in enthalpy in c";
    Real Tdash(unit = "K") "Adiabatic temperature of system";
    Real gamma(unit = "J/(mol K)") "cp/cv";
    Real V1(unit = "m^3") "Initial volume of system";
    Real V2(unit = "m^3") "Final volume of system";
    //==================================
    //Equation section
  equation
    cp = 7 / 2 * R;
    cv = 5 / 2 * R;
    deltaU = 0;
//constant temperature at beginning and end
    deltaH = 0;
    gamma = cp / cv;
    V1 = 0.02479;
//from figure 3.7 corresponding to P1
    V2 = 0.004958;
//from figure 3.7 corresponding to P2
    Tdash = T1 * (V1 / V2) ^ (gamma - 1);
    W = cv * (Tdash - T1);
    Q = cv * (T1 - Tdash);
//for constant volume process
  end Ex3_2_c;

  //==================================
end Ex3_2;
