//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-3:Volumetric properties of pure fluids
//Example: 3.7 Page 85
//Title: Find kinetic energy and temperature change of air
//==================================================================================
model Ex3_7

//==================================
// Library section
extends Modelica.Constants ;

//==================================
//Parameter section
parameter Real P1(unit = "bar") = 6 "Upstream pressure";
parameter Real P2(unit = "bar") = 3 "Downstream pressure";
parameter Real T1(unit = "K") = 293.15 "Initial temperature of system";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";
parameter Real n(unit = "mol/s") =1 "Molar flow rate";
parameter Real M(unit = "g/mol") =29 "Molecular weight of air";
parameter Real D(unit = "cm") =5 "Inner diameter of pipe";

//==================================
//Variable section
Real cp(unit = "J/(mol K)") "Constant pressure heat capacity";
Real A(unit = "m^2") "Area of cross section";
Real V1(unit = "m^3") "Upstream molar volume";
Real u1(unit = "m/s") "Upstream velocity of flow";
Real V2(unit = "m^3") "Downstream molar volume";
Real u2(unit = "m/s") "Downstream velocity of flow";
Real deltaKE(unit = "W") "Change in kinetic energy";
Real deltaT(unit = "K") "Change in temperature";

//==================================
//Equation section
equation
cp = (7/2)*R;
A = pi/4*(D*0.01)^2;//to convert cm to m
V1 = R*T1/(P1*10^5);//to convert bar to Pa
u1 = n*V1/A;
V2 = 2*V1;//approximation
u2 = 2*u1;
deltaKE = n*M*0.001*(u2^2-u1^2)/2;//to convert g to kg
deltaT = -deltaKE/(cp*n);//from energy balance

end Ex3_7;
//==================================================================================
