package Ex3_9
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-3:Volumetric properties of pure fluids
  //Example: 3.9 Page 98
  //Title: Molar volume by Redlich/Kwong equation
  //==================================================================================

  model Ex3_9_a
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 9.4573 "Pressure of system";
    parameter Real T(unit = "K") = 350 "Temperature of system";
    parameter Real si(unit = "") = 0.42748 "RK parameters";
    //from Table 3.1
    parameter Real omega(unit = "") = 0.08664 "RK parameters";
    parameter Real epsilon(unit = "") = 0 "RK parameters";
    parameter Real sigma(unit = "") = 1 "RK parameters";
    parameter Real Pc(unit = "bar") = 37.96 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 425.1 "Critical temperature of system";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real Tr(unit = "") "Reduced temperature";
    Real Pr(unit = "") "Reduced Pressure";
    Real q(unit = "") "RK parameters";
    Real beta(unit = "") "RK parameters";
    Real Z(start = 1) "Compressibility factor for a";
    Real Vv(unit = "cm^3/mol") "Volume for a";
    //==================================
    //Equation section
  equation
    Tr = T / Tc;
    Pr = P / Pc;
    q = si * Tr ^ (-3 / 2) / omega;
    beta = omega * Pr / Tr;
    Z = 1 + beta - q * beta * (Z - beta) / (Z * (Z + beta));
    Vv = Z * R * T / P;
  end Ex3_9_a;

  //==================================

  model Ex3_9_b
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 9.4573 "Pressure of system";
    parameter Real T(unit = "K") = 350 "Temperature of system";
    parameter Real si(unit = "") = 0.42748 "RK parameters";
    //from Table 3.1
    parameter Real omega(unit = "") = 0.08664 "RK parameters";
    parameter Real epsilon(unit = "") = 0 "RK parameters";
    parameter Real sigma(unit = "") = 1 "RK parameters";
    parameter Real Pc(unit = "bar") = 37.96 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 425.1 "Critical temperature of system";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real Tr(unit = "") "Reduced temperature";
    Real Pr(unit = "") "Reduced Pressure";
    Real q(unit = "") "RK parameters";
    Real beta(unit = "") "RK parameters";
    Real Z(unit = "") "Compressibility factor for b";
    Real Vl(unit = "cm^3/mol") "Volume for b";
    //==================================
    //Equation section
  equation
    Tr = T / Tc;
    Pr = P / Pc;
    q = si * Tr ^ (-3 / 2) / omega;
    beta = omega * Pr / Tr;
    Z = beta + Z * (Z + beta) * ((1 + beta - Z) / (q * beta));
    Vl = Z * R * T / P;
  end Ex3_9_b;

  //==================================
end Ex3_9;
