//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.7 Page 142
//Title: Calculate maximum temperature reached in combustion of methane
//==================================================================================
model Ex4_7

//==================================
//Parameter section
parameter Real T0(unit = "K") =298.15 "Standard temperature"; 
parameter Real[4] n(unit = "") ={1,2,0.4,9.03} "No. of moles of CO2,H2O,O2,N2";
parameter Real[4] A(unit = "") ={5.457,3.470,3.639,3.280} "Cp constants of CO2,H2O,O2,N2";
parameter Real[4] B(unit = "") ={1.045,1.450,0.506,0.593} "Cp constants of CO2,H2O,O2,N2";
parameter Real[4] C(unit = "") ={0,0,0,0} "Cp constants of CO2,H2O,O2,N2";
parameter Real[4] D(unit = "") ={-1.157,0.121,-0.227,0.040} "Cp constants of CO2,H2O,O2,N2";
parameter Real[3] deltaHf(unit = "J") ={-74520,-241818,-393509} "Heat of formations of CH4,O2,CO2";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";

//==================================
//Variable section
Real T(start = 298.15, unit = "K") "Temperature of reaction";
Real deltaH0(unit= "J") "Heat of reaction at 298.15 K";
Real deltaA(unit= "") "Cp constant";
Real deltaB(unit= "") "Cp constant";
Real deltaC(unit= "") "Cp constant";
Real deltaD(unit= "") "Cp constant";
Real cph(unit="J/K mol");

//==================================
//Equation section
equation
deltaH0 = -deltaHf[1]+2*deltaHf[2]+deltaHf[3];
deltaA = n[1]*A[1]+n[2]*A[2]+n[3]*A[3]+n[4]*A[4];
deltaB = (n[1]*B[1]+n[2]*B[2]+n[3]*B[3]+n[4]*B[4])*(1/10)^3;
deltaC = (n[1]*C[1]+n[2]*C[2]+n[3]*C[3]+n[4]*C[4])*(1/10)^6;
deltaD = (n[1]*D[1]+n[2]*D[2]+n[3]*D[3]+n[4]*D[4])*(10)^5;
T = T0-deltaH0/cph;
cph=(R*deltaA+deltaB/2*T0*(T/T0+1)+deltaD/((T/T0)*T0^2));

//The answer may vary due to rounding off values

end Ex4_7;
//==================================================================================
