//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.9 Page 147
//Title: Calculate fraction of heat of combustion of oil transferred to boiler
//==================================================================================
model Ex4_9

//==================================
//Parameter section
parameter Real T(unit = "K") =573.15 "Temperature of reaction";
parameter Real T0(unit = "K") =298.15 "Reference temperature";
parameter Real[4] n(unit = "mol") ={11.2,0.4,6.2,82.2} "Moles of CO2, CO, O2, N2 respectively";
parameter Real[5] A(unit = "") ={5.457,3.376,3.470,3.639,3.280} "Cp constants for CO2, CO, H2O, O2, N2 respectively";
parameter Real[5] B(unit = "") ={1.045E-3,0.557E-3,1.450E-3,0.506E-3,0.593E-3} "Cp constants for CO2, CO, H2O, O2, N2 respectively";
parameter Real[5] C(unit = "") ={0,0,0,0,0} "Cp constants for CO2, CO, H2O, O2, N2 respectively";
parameter Real[5] D(unit = "") ={-1.157E+5,-0.031E5,0.121E5,-0.227E5,0.040E5} "Cp constants for CO2, CO, H2O, O2, N2 respectively";
parameter Real H(unit="J/g") =-43515 "Standard heat of combustion at 298.15 K";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";

//==================================
//Variable section
Real tau(unit = "") "Ratio of reaction and reference temperature";
Real n_O2_1(unit = "mole") "Moles of O2 entering in air";
Real n_O2_2(unit = "mole") "Moles of O2 indry flue gas";
Real n_H2O(unit = "mole") "Moles of H2O formed and H2 in fuel";
Real n_C(unit = "mole") "Moles of C in flue gases and in fuel";
Real m(unit = "g") "Mass of fuel burnt";
Real deltaH_0_1(unit = "J") "Change in enthalpy of reaction at reference temperature if complete fuel is burnt";
Real deltaH_0_2(unit = "J") "Actual change in enthalpy of reaction at reference temperature ";
Real deltaH_P(unit = "J") "Change in enthalpy of products";
Real deltaH(unit = "J") "Change in enthalpy of reaction";
Real[5] Cp0byR(unit = "") "Cp constants for CO2, CO, H2O, O2, N2 respectively";
Real f(unit="%") "Fraction of heat of combustion of oil transferred to boiler";

//==================================
//Equation section
equation
n_O2_1 = n[4]*21/79;
n_O2_2 = n[1]+n[2]/2+n[3];
n_H2O = (n_O2_1-n_O2_2)*2;
n_C =n[1]+n[2];
m = n_H2O*2+n_C*12; //multiply by mass of components present
deltaH_0_1 = H*m;
deltaH_0_2 = deltaH_0_1+44012*n_H2O+282984*n[2]; //where latentheat of water=44012 J & Heat of CO2 to CO conversion is 282984 J 
tau = T/T0;
for i in 1:5 loop
Cp0byR[i] = (A[i]+B[i]/2*T0*(tau+1)+C[i]/3*T0^2*(tau^2+tau+1)+D[i]/((tau)*T0^2));
end for;
deltaH_P = R*(n[1]*Cp0byR[1]+n[2]*Cp0byR[2]+n_H2O*Cp0byR[3]+n[3]*Cp0byR[4]+n[4]*Cp0byR[5])*(T-T0);
deltaH = deltaH_0_2+deltaH_P;
f = abs(deltaH/deltaH_0_1)*100;

end Ex4_9;
//==================================================================================