//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.1 Page 166
//Title: Calculate heat discarded to river
//==================================================================================
model Ex5_1

//==================================
//Parameter section
parameter Real TH(unit="K")=585 "Steam generation temperature";
parameter Real TC(unit="K")=295 "River temperature";
parameter Real W(unit="kW")=800000 "Power supplied to plant";
parameter Real eff(unit="%")=70 "Efficiency of plant";

//==================================
//Variable section
Real nmax(unit="") "Maximum possible thermal efficiency";
Real n(unit="") "Thermal efficiency";
Real Qc(unit="kW") "Heat discarded to river";

//==================================
//Equation section
equation
nmax = 1-TC/TH;
n = eff/100*nmax;
Qc = (1-n)/n*W;

end Ex5_1;
//==================================================================================

