//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.5 Page 177
//Title: Calculate rate of heat transfer and entropy generation during mixing
//==================================================================================
model Ex5_5

//==================================
//Parameter section
parameter Real nA(unit="mol/s")=1 "Mole rate of stream 1 air";
parameter Real nB(unit="mol/s")=2 "Mole rate of stream 2 air";
parameter Real TA(unit="K")=600 "Temperature of stream 1 air";
parameter Real TB(unit="K")=450 "Temperature of stream 2 air";
parameter Real T(unit="K")=400 "Temperature of product air";
parameter Real Tsigma(unit="K")=300 "Surrounding temperature";
parameter Real R(unit="J/(mol K)")=8.314 "Universal gas constant";
 
//==================================
//Variable section
Real Q(unit="J/s") "Rate of heat transfer";
Real SG(unit="J/(K s)") "Rate of entropy generation";
 
//==================================
//Equation section
equation
Q = 7/2*R*(nA*(T-TA)+nB*(T-TB));
SG = 7/2*R*(nA*log(T/TA)+nB*log(T/TB))-Q/Tsigma;
 
end Ex5_5;
//==================================================================================