//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.7 Page 182
//Title: Calculate maximum work obtained in nitrogen system
//==================================================================================
model Ex5_7

//==================================
//Parameter section
parameter Real T1(unit="K")=800 "Temperature of nitrogen";
parameter Real P1(unit="bar")=50 "Pressure of nitrogen";
parameter Real T2(unit="K")=300 "Temperature of surrounding";
parameter Real P2(unit="bar")=1.013 "Atmospheric pressure";
parameter Real n(unit="mol")=1 "Number of moles of nitrogen";
parameter Real A(unit = "") =3.280 "Cp constants of N2";
parameter Real B(unit = "") =0.593E-3 "Cp constants of N2";
parameter Real C(unit = "") =0 "Cp constants of N2";
parameter Real D(unit = "") =0.040E5 "Cp constants of N2";
parameter Real R(unit="J/(mol k)")=8.314 "Universal gas constant";

//==================================
//Variable section
Real deltaH(unit="J/mol") "Total change in entropy change";
Real deltaS(unit="J/(K mol)") "Total change in entropy change";
Real Wideal(unit="J/mol") "Maximum work an ideal system";

//==================================
//Equation section
equation
deltaH = R*(A*T1*(T2/T1-1)+B/2*T1^2*((T2/T1)^2-1)+C/3*T1^3*((T2/T1)^3-1)+D/T1*(T2/T1-1)/(T2/T1));
deltaS = R*(A*log(T2/T1)+(B*T1+(C*T1^2+D/((T2/T1)^2*T1^2))*(T2/T1+1)/2)*(T2/T1-1))-R*log(P2/P1);
Wideal = deltaH-T2*deltaS;

end Ex5_7;
//==================================================================================