//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.1 Page 204
//Title: Enthalpy and entropy changes for liquid water
//==================================================================================
model Ex6_1

//==================================
//Parameter section
parameter Real T1(unit="K")=298.15 "Initial temperature of liquid water";
parameter Real T2(unit="K")=323.15 "Final temperature of liquid water";
parameter Real P1(unit="bar")=1 "Initial pressure of liquid water";
parameter Real P2(unit="bar")=1000 "Final pressure of liquid water";
parameter Real cp_T1(unit="J/(mol K)")=75.305 "Cp value at T=298.15 K";
parameter Real cp_T2(unit="J/(mol K)")=75.314 "Cp value at T=323.15 K";
parameter Real[4] V_(unit="cm^3/mol")={18.071,18.012,18.234,18.174} "Volume of water";
parameter Real[4] beta_(unit="1/K")={256E-6,366E-6,458E-6,568E-6} ;

//==================================
//Variable section
Real cp(unit="J/(mol K") "Cp value at 1 bar";
Real V(unit="J/(mol K") "Volume of liquid at T=323.15 K";
Real beta(unit="1/ K") "Beta at T=323.15 K";
Real deltaH(unit="J/mol") "Enthalpy of system";
Real deltaS(unit="J/mol K") "Entropy of system";

//==================================
//Equation section
equation
cp = (cp_T1+cp_T2)/2;
V = (V_[3]+V_[4])/2;
beta = (beta_[3]+beta_[4])/2;
deltaH = cp*(T2-T1)+(1-beta*T2)*V*(P2-P1)/10; //from Eqn 6.28 & 6.27
deltaS = cp*log(T2/T1)-beta*V*(P2-P1)/10;

end Ex6_1;
//==================================================================================
