//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.3 Page 213
//Title: Estimate enthalpy and entropy of isobutene
//==================================================================================
model Ex6_3

//==================================
//Parameter section
parameter Real T(unit="K")=360 "Temperature of system";
parameter Real T0(unit="K")=300 "Reference temperature of system";
parameter Real P(unit="bar")=15.41 "Pressure of system";
parameter Real H0(unit="J/mol")=18115 "Enthalpy of reference state";
parameter Real S0(unit="J/mol K")=295.976 "Entropy of reference state";
parameter Real[11] x(unit="bar")={0,0.10,0.50,2,4,6,8,10,12,14,15.41} "Pressure";
parameter Real[11] y1(unit="1/K bar")={1.780,1.700,1.514,1.293,1.290,1.395,1.560,1.777,2.073,2.432,2.720} "(dZ/dT)p/P*10^4";
parameter Real[11] y2(unit="1/bar")={2.590,2.470,2.186,1.759,1.591,1.544,1.552,1.592,1.658,1.750,1.835} "-(Z-1)/P*10^2";
parameter Real R(unit="J/K mol")=8.314 "Universal gas constant";

//==================================
//Variable section
Real H(unit="J/mol") "Enthalpy of system";
Real S(unit="J/mol K") "Entropy of system";
Real HR(unit="J/mol") "Reduced enthalpy of system";
Real SR(unit="J/mol K") "Reduced entropy of system";
Real I1[11](unit="1/K") "Value of first integral";
Real I2[11](unit="") "Value of second integral";
Real i(unit="") "Control varialble";

//==================================
//Equation section
equation
i=2;
I1[1] = 0;
for i in 2:11 loop
I1[i] = I1[i-1]+((x[i]-x[i-1])*y1[i]/10^4);
end for;
I2[1] = 0;
for i in 2:11 loop
I2[i] = I2[i-1]+((x[i-1]-x[i])*y2[i]/10^2);
end for;
HR = -I1[11]*T*R*T;
SR = (-I2[11]+HR/(R*T))*R;
H = (R*(1.7765+0.03303/2*T0*((T/T0)+1))*(T-T0))+H0+HR;
S = (R*(1.7765*log(T/T0)+(0.03303*T0)*((T/T0)-1)))+S0-R*log(P)+SR;
//The answer may slightly vary due to rounding off values

end Ex6_3;
//==================================================================================