//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.4 Page 219
//Title: Find values for residual enthalpy and entropy
//==================================================================================
model Ex6_4

//==================================
//Parameter section
parameter Real T(unit="K")=500 "Temperature of system";
parameter Real P(unit="bar")=50 "Pressure of system";
parameter Real R(unit="J/K mol")=8.314 "Universal gas constant";
parameter Real Tc(unit="K")=425.1 "Critical temperature of system";
parameter Real Pc(unit="bar")=37.96 "Critical pressure of system";
parameter Real omega(unit="")=0.08664 "Equation constant";
parameter Real si(unit="")=0.42748 "Equation constant";

//==================================
//Variable section
Real Tr(unit="K") "Reduced temperature";
Real Pr(unit="bar") "Reduced pressure";
Real beta(unit="") "Equation constant";
Real Z(unit="") "Compressibility factor";
Real q(unit="") "Equation constant";
Real I(unit="") "Integral value";
Real HR(unit="J/mol") "Residual enthalpy";
Real SR(unit="J/mol K") "Residual entropy";

//==================================
//Equation section
equation
Tr = T/Tc;
Pr = P/Pc;
beta = omega*Pr/Tr;
q = si/(omega*Tr^1.5);
Z = 1+beta-q*beta*(Z-beta)/(Z*(Z+beta));
I = log((Z+beta)/Z);
HR = (Z-1+(-0.5-1)*q*I)*R*T;//(HR/RT)=Z-1+[(d ln(alphaTr)/d ln Tr)-1]*q*I 
SR = (log(Z-beta)-0.5*q*I)*R;//SR/R=ln(Z-beta)+[d ln(alphaTr)/d ln Tr]*q*I

end Ex6_4;
//==================================================================================
