//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.9 Page 235
//Title: Estimate properties of 1-butene vapor
//==================================================================================
model Ex6_9

//==================================
//Parameter section
parameter Real T1(unit="K")=473.15 "Temperature of system";
parameter Real P1(unit="bar")=70 "Pressure of system";
parameter Real P2(unit="bar")=1.2771 "Pressure of system";
parameter Real Td(unit="K")=273.15 "Temperature of saturated liquid";
parameter Real Tc(unit="K")=420 "Critical temperature of system";
parameter Real Pc(unit="bar")=40.43 "Critical pressure of system";
parameter Real omega(unit="")=0.191 "Critical constant of system";
parameter Real Tn(unit="K")=266.9 "Normal boiling temperature of system";
parameter Real Z0(unit="")=0.485 "Compressibilty factor of system";
parameter Real Z1(unit="")=0.142 "Compressibilty factor of system";
parameter Real R(unit="J/K mol")=8.314 "Universal gas constant";

//==================================
//Variable section
Real Tr(unit="K") "Reduced temperature of system";
Real Tr1(unit="K") "Reduced temperature of system at 273.15 K";
Real Trn(unit="K") "Reduced normal boiling temperature of system";
Real Pr(unit="bar") "Reduced pressure of system";
Real Pr1(unit="bar") "Reduced pressure of system at 1 atm";
Real Z(unit="") "Compressibilty factor of system";
Real V(unit="cm^3/mol") "Volume of mixture";
Real A(unit="") "Antoine constants";
Real B(unit="") "Antoine constants";
Real deltaHlvn(unit="J/mol") "Enthalpy at normal boiling point";
Real deltaHlv(unit="J/mol") "Enthalpy at 273.15 K";
Real deltaSlv(unit="J/mol K") "Entropy at 273.15 K";
Real deltaHig(unit="J/mol") "Enthalpy of ideal gas";
Real deltaSig(unit="J/mol K") "Entropy of ideal gas";
Real H1R(unit="J/mol") "Residual enthalpy";
Real S1R(unit="J/mol K") "Residual entropy";
Real H2R(unit="J/mol") "Residual enthalpy";
Real S2R(unit="J/mol K") "Residual entropy";
Real B0(unit="") "Quantity B0";
Real B1(unit="") "Quantity B1";
Real diffB0(unit="") "dB0/dt";
Real diffB1(unit="") "dB1/dt";
Real H(unit="J/mol") "Total enthalpy change";
Real S(unit="J/mol K") "Total entropy change";
Real U(unit="J/mol") "Total internal energy change";

//==================================
//Equation section
equation
Tr = T1/Tc;
Tr1 = Td/Tc;
Trn = Tn/Tc;
Pr = P1/Pc;
Pr1 = 1.2771/Pc;
Z = Z0+omega*Z1;
V = Z*R*T1/P1;
//a
log(1.0133) = A-B/266.9;
log(40.43) = A-B/420;
deltaHlvn = R*Tn*1.092*(log(Pc)-1.013)/(0.930-Trn);
deltaHlv/deltaHlvn = ((1-Tr1)/(1-Trn))^0.38;
deltaSlv = deltaHlv/Td;
//b
H1R = R*Tc*Pr1*(B0-Tr1*diffB0+omega*(B1-Tr1*diffB1));
B0 = 0.083-0.422/Tr1^1.6;
B1 = 0.139-0.172/Tr1^4.2;
diffB0 = 0.675/Tr1^2.6;
diffB1 = 0.722/Tr1^5.2;
S1R = -R*Pr1*(diffB0+omega*diffB1);
//c
deltaHig = (1.967+31.630E-3/2*Td*(T1/Td+1)-9.837E-6/3*Td^2*((T1/Td)^2+(T1/Td)+1)+0/T1^2)*R*(T1-Td);
deltaSig = R*(1.967*log(T1/Td)+(31.630E-3*Td+(-9.837E-6*Td^2+0/T1^2)*((T1/Td)+1)/2)*((T1/Td)-1))-R*log(P1/P2);

//d
H2R = R*Tc*(-2.294-0.713*omega);
S2R = R*(-1.566+(-0.726)*omega);
H = deltaHlv-H1R+deltaHig+H2R;
S = deltaSlv-S1R+deltaSig+S2R;
U = H-P1*V;

end Ex6_9;
//==================================================================================
