//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.4 Page 265
//Title: Calculate final temperature of propane and its entropy change
//==================================================================================
model Ex7_4

//==================================
//Parameter section
parameter Real P1(unit="bar")=20 "Initial pressure";
parameter Real T1(unit="K")=400 "Initial temperature";
parameter Real P2(unit="bar")=1 "Discharge pressure";
parameter Real Tc(unit="K")=369.8 "Critical temperature";
parameter Real Pc(unit="bar")=42.48 "Critical pressure";
parameter Real R(unit="J/ mol K")=8.314 "Univeral gas constant";
parameter Real omega(unit="")=0.152 "";
parameter Real i(unit="")=1 "Control variable";

//==================================
//Variable section
Real[2] T2(unit="K") "Discharge temperature";
Real[2] Tr1(unit="K") "Initial reduced temperature";
Real[2] Pr1(unit="bar") "Initial reduced pressure";
Real[2] H1R(unit="J/kg") "Initial enthalpy";
Real[2] T(unit="K") "Guess termperature";
Real[2] B0(unit="") "Quantity B0";
Real[2] B1(unit="") "Quantity B1";
Real[2] diffB0(unit="") "dB0/dt";
Real[2] diffB1(unit="") "dB1/dt";
Real[2] cp(unit="J/(mol K") "Heat capacity";
Real[2] Tam(unit="K") "Average temperature";
Real deltaS(unit="J/(mol K)") "Change in entropy";
Real S1R(unit="J/(mol K)") "Initial entropy";

//==================================
//Equation section
equation
T[1] = T1;
for i in 1:2 loop
Tr1[i] = T[i]/Tc;
Pr1[i] = P1/Pc;
H1R[i] = R*Tc*Pr1[i]*(B0[i]-Tr1[i]*diffB0[i]+omega*(B1[i]-Tr1[i]*diffB1[i]));
B0[i] = 0.083-0.422/Tr1[i]^1.6;
B1[i] = 0.139-0.172/Tr1[i]^4.2;
diffB0[i] = 0.675/Tr1[i]^2.6;
diffB1[i] = 0.722/Tr1[i]^5.2;
cp[i] = R*(1.213+0.028785*T[i]-0.000008824*T[i]^2);
T2[i] =H1R[i]/cp[i]+T[i];
Tam[i] = (T[i]+T2[i])/2;
end for;
T[2] = Tam[1];

S1R = -R*Pr1[1]*(diffB0[1]+omega*diffB1[1]);
deltaS = cp[2]*log(T2[1]/T1)-R*log(P2/P1)-S1R;

end Ex7_4;
//==================================================================================