//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-10: Pumps, Compressors and Turbines
//Example: 10.5 Page 373
//Title: Centrifugal Pumps and Compressors
//===================================================================

model Ex10_5

//=============
// Parameter Section

parameter Real r_v(unit = "rpm") = 1750 "Rotational velocity of the pump";
parameter Real p_di(unit = "in") = 2.067 "Diameter of inlet pipe";
parameter Real p_do(unit = "in") = 1.61 "Diameter of outlet pipe";
parameter Real i_di(unit = "ft") = 0.086 "Inner diameter of the impeller";
parameter Real i_do(unit = "ft") = 0.336 "Outer diameter of the impeller";
parameter Real v(unit = "gal/min") = 100 "Volumetric flowrate of the fluid";
parameter Real c1(unit = "in3/gal") = 231 "Conversion factor";
parameter Real c2(unit = "s/min") = 60 "Conversion factor";
parameter Real c3(unit = "in/ft") = 12 "Conversion factor";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real omega(unit = "1/s") "Angular velocity of the pump";
Real v1(unit = "ft/s") "Velocity in the inlet pipe";
Real v2(unit = "ft/s") "Velocity in the outlet pipe";
Real h(unit = "ft") "Pump head";

//=============
// Equation Section

equation
omega = r_v * 2 * pi / c2;
v1 = v * c1 / ( (pi/4) * (p_di)^2 * c2 * c3);
v2 = v * c1 / ( (pi/4) * (p_do)^2 * c2 * c3);
h = ( (omega)^2 * ((i_do)^2 - (i_di)^2) / g ) + ( ( (v2)^2 - (v1)^2 ) / (2 * g) );

//Value of "h" do not match with the book answer due to calculation error in the book.
end Ex10_5;