//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-17: The Boundary Layer
//Example: 17.2 Page 521
//Title: Boundary Layer Thickness
//===================================================================

model Ex17_2

//=============
// Parameter Section

parameter Real V(unit = "m/h") = 15000 "Velocity of the ship";
parameter Real x(unit = "m") = 1 "Length of the square plate";
parameter Real v(unit = "m2/s") = 1.004 * 10^(-6) "Kinematic viscosity of water";
parameter Real c1(unit = "s/h") = 3600 "Conversion factor";
parameter Real rho(unit = "kg/m3") = 998.2 "Density of water";
parameter Real A(unit = "m2") = 1 "Area of the square plate";

//=============
// Variable Section

Real R(unit = "NA") "Reynolds number";
Real Cf(unit = "NA") "Local drag coefficient";
Real F(unit  = "N") "Force required to tow the plate";

//=============
// Equation Section

equation
R = (V * x) / (v * c1);
Cf = 1.328 / (R)^0.5;
F = Cf * 0.5 * rho * (V/c1)^2 * (2 * A);

end Ex17_2;