//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-18: Turbulence 
//Example: 18.4 Page 551
//Title: Scale of Turbulence
//===================================================================

model Ex18_4

//=============
// Parameter Section

parameter Real v(unit = "ft2/s") = 1.616 * 10^(-4) "Kinematic viscosity of air";
parameter Real E(unit = "ft2/s3") = 0.21 "Dissipaation rate";

//=============
// Variable Section

Real K(unit = "ft") "Kolmogorov scale";

//=============
// Equation Section

equation
K = (v^3 / E)^0.25;

end Ex18_4;