//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-18: Turbulence 
//Example: 18.7 Page 557
//Title: Finding Eddies from Semi theoretical Correlations
//===================================================================

model Ex18_7

//=============
// Parameter Section

parameter Real k(unit = "m2/s2") = 0.00576 "Turbulent ke per unit mass";
parameter Real E(unit = "m2/s3") = 0.0196 "Dissipation rate";
parameter Real C(unit = "NA") = 0.09;

//=============
// Variable Section

Real vt(unit = "m2/s") "Turbulent kinmeatic viscosity";

//=============
// Equation Section

equation

vt = 0.09 * k^2 / E;

end Ex18_7;