//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.1 Page 40
//Title: Basic Equation of Fluid Statics
//===================================================================

model Ex2_1

//=============
// Parameter Section 

parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real c1(unit = "lbm.s2/lbm.ft") = 32.2 "Conversion factor";

//=============
// Variable Section

Real s(unit = "lbf/ft3") "Specific gravity of water";

//=============
// Equation Section  

equation
s = rho * g / c1;

end Ex2_1;