//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.11 Page 53
//Title: Buoyancy
//===================================================================

model Ex2_11

//=============
// Parameter Section

parameter Real D(unit = "m") = 3 "Diameter of the balloon";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real P(unit = "atm") = 1 "Pressure of the balloon";
parameter Real R(unit = "m3.atm/mol.K") = 8.2 * 10^(-5) "universal gas constant";
parameter Real T(unit = "K") = 293.15 "Temperature of the surrounding air";
parameter Real M_air(unit = "g/mol") = 29 "Molecular weight of air";
parameter Real M_hel(unit = "g/mol") = 4 "Molecular weight of helium";
parameter Real c1(unit = "g/kg") = 1000 "Conversion factor";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real payload(unit = "N") "Payload that the balloon can lift";

//=============
// Equation Section

equation
payload = (pi/6) * (D)^3 * g * P * ( M_air - M_hel ) / ( R * T * c1 );

end Ex2_11;