//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.15 Page 57
//Title: Pressure Measurement
//===================================================================

model Ex2_15

//=============
// Parameter Section

parameter Real k(unit = "N/cm") = 100 "Spring constant";
parameter Real delx(unit = "cm") = 2.5 "Distance moved by the pointer";
parameter Real A(unit = "cm2") = 100 "Area of the piston";
parameter Real c1(unit = "cm2/m2") = 10000 "Conversion factor";

//=============
// Variable Section

Real P_tank(unit = "Pa") "Pressure in the tank";

//=============
// Equation Section

equation

P_tank = ( k * delx * c1 ) / A;
end Ex2_15;