//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.2 Page 40
//Title: Pressure Depth Relations
//===================================================================

model Ex2_2

//=============
// Parameter Section 

parameter Real P_a(unit = "lbf/in2") = 14.7 "Atmpsheric pressure above the sea";
parameter Real rho(unit = "lbm/ft3") = 63.9 "Density of the sea";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real d(unit = "ft") = 1000 "Depth at which the accident occured";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real P_t(unit = "lbf/in2") "Total pressure at the given depth";

//=============
// Equation Section

equation
P_t = P_a + (rho * g * d / (c1 * c2));  
end Ex2_2;