//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-3: The Balance Equation and the Mass Balance
//Example: 3.5 Page 90
//Title: Velocity Distributors
//===================================================================

model Ex3_5

//=============
// Parameter Section 

parameter Real v_1(unit = "ft/s") = 50 "Velocity of natural gas at staion 1";
parameter Real rho_1(unit = "lbm/ft3") = 2.58 "Density of natural gas at station 1";
parameter Real d_1(unit = "ft") = 2 "Diameter of the pipe at station 1";
parameter Real rho_2(unit = "lbm/ft3") = 1.54 "Density of natural gas at station 2";
parameter Real d_2(unit = "ft") = 3 "Diameter of natural gas at station 2";

//=============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section 

Real v_2(unit = "ft/s") "Velocity of natural gas at staion 2";
Real m(unit = "lbm/s") "Mass flowrate of the natural gas";

//=============
// Equation Section 

equation
v_2 = ( v_1 * rho_1 * (pi * d_1^2 / 4) ) / ( rho_2 * (pi * d_2^2 / 4));
m = rho_1 * v_1 * (pi/4) * (d_1)^2;
end Ex3_5;