//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.6 Page 124
//Title: Nuclear Power Plant
//===================================================================

model Ex4_6

//=============
// Parameter Section 

parameter Real dW(unit = "W") = 7 * 10^8 "Amount of energy produced";
parameter Real dQ(unit = "W") = 13 * 10^8 "Amount of heat rejected" ;
parameter Real c(unit = "m/s") = 2.99 *10^8 "Speed of light in vacuum";

//=============
// Variable Section 

Real dm(unit = "kg") "Amount of matter being converted to energy";
Real dmdt(unit ="kg/s") "Amount of matter being converted to energy per second";

//=============
// Equation Section

//Assuming basis to be 1 second
equation
dm = (- dQ - dW) / c^2; 
dmdt = dm;
end Ex4_6;