//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.19 Page 223
//Title: Flow around Submerged Objects
//===================================================================

model Ex6_19

//=============
// Parameter Section

parameter Real d(unit = "m") = 10^(-6) "Diameter of the particle";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real rho_s(unit = "kg/m3") = 2000 "Density of particle";
parameter Real rho_a(unit = "kg/m3") = 1.2 "Density of air";
parameter Real u(unit = "Pa.s") = 1.8 * 10^(-5) "Viscosity of air";

//=============
// Variable Section

Real v(unit = "m/s") "Velocity of dust particle";

//=============
// Equation Section

equation

v = ( ( g * d^2 * (rho_s  - rho_a) ) / (18 * u) );

end Ex6_19;