//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.2 Page 248
//Title: Duck-Bullet System
//===================================================================

model Ex7_2

//=============
// Parameter Section 

parameter Real m_d(unit = "lbm") = 3 "Mass of the duck";
parameter Real v_d(unit = "ft/s") = 15 "Initial speed of the duck";
parameter Real m_b(unit = "lbm") = 0.05 "Mass of the bullet";
parameter Real v_b(unit = "ft/s") = 1000 "Initial speed of the bullet";

//=============
// Variable Section

Real m_db(unit = "lbm") "Sum of the duck and the bullet system";
Real v_fin(unit = "ft/s") "Final speed of the system";

//=============
// Equation Section
 
equation
m_db = m_d + m_b;
v_fin = ((m_d * (- v_d)) + (m_b * v_b)) / m_db; // Negative sign for sign convention 
end Ex7_2;