//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.3 Page 250
//Title: Jet Surface Interactions
//===================================================================

model Ex7_3

//=============
// Parameter Section 

parameter Real m(unit = "m3/s") = 0.01 "Volumetric flowrate of the fluid";
parameter Real v_int(unit = "m/s") = 30 "Initial velocity of the fluid";
parameter Real v_fin(unit = "m/s") = 0 "Final velocity of the fluid";
parameter Real rho(unit = "kg/m3") = 998.2 "Density of the fluid";

//=============
// Variable Section 

Real F(unit = "N") "Force required to hold the lid";

//=============
// Equation Section

equation
F = (- m) * rho * (v_int - v_fin);

end Ex7_3;