//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.9 Page 258
//Title: Specific Impulse of Exhaust gas from a Rocket
//===================================================================

model Ex7_9

//=============
// Parameter Section

parameter Real v(unit = "m/s") = -3000 "Velocity of the outlet";

//=============
// Variable Section

Real I_sp(unit = "kN.s/kg") "Specific Impulse of the exhaust gas";

//=============
// Equation Section

equation
I_sp = -(v)/1000; //Conversion from N to kN

end Ex7_9;