//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.2 Page 300
//Title: Speed of Sound
//===================================================================

model Ex8_2

//=============
// Parameter Section
parameter Real R(unit = "ft2.lbm/s2.lbmol.°R") = 49729 "Constant R";
parameter Real k(unit = "NA") = 1.4 "Ratio of specific heats";
parameter Real T(unit = "°R") = 528 "Temperature of air";
parameter Real M(unit = "lbm/lbmol") = 29 "Molecular mass of air";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real c_a(unit = "ft/s") "Speed of sound in air";

//=============
// Equation Section

equation
c_a = sqrt(k * R * T / M);

end Ex8_2;