//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-1: Introduction
//Example: 1.3 Page 14
//Title: Surface Tension in a Wire Frame
//===================================================================

model Ex1_3

//=============
// Parameter Section 

parameter Real one_newton(unit = "lbf/N") = 0.224809 "One newton in terms of pound force";
parameter Real one_meter(unit = "in/m") = 39.3701 "One meter in terms of inches";
parameter Real force(unit = "N") = 0.00589 "Force exerted by the frame";
parameter Real length(unit = "m") = 0.1 "Length of the frame";


//=============
// Variable Section 

Real force_actual(unit = "N") "Force acting on one surface";
Real s_tension_si(unit = "N/m") "Surface tension exerted by one of the two surfaces in S.I. units";
Real s_tension(unit = "lbf/in") "Surface tension in pound force per inch";


//=============
// Equation Section 

equation

force_actual = force * 0.5;
s_tension_si = force_actual / length; 
s_tension = s_tension * one_newton / one_meter; 
// Force multiplied with 0.5 to account for one surface out of the two


end Ex1_3;
//===================================================================
