//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-10: Pumps, Compressors and Turbines
//Example: 10.1 Page 362
//Title: General Relations for all Pumps, Compressors and Turbines
//===================================================================

model Ex10_1

//=============
// Parameter Section

parameter Real m(unit = "gal/min")  = 50 "Mass flowrate of water";
parameter Real p_i(unit = "psia") = 30 "Initial pressure of the pump";
parameter Real p_f(unit = "psia") = 100 "Final pressure of the pump";
parameter Real P(unit = "hp") = 2.8 "Power supplied";
parameter Real d(unit = "in3/gal") = 231 "Specific gravity of water";
parameter Real c1(unit = "ft.lbf/hp.min") = 33000 "Conversion factor";
parameter Real c2(unit = "in/ft") = 12 "Conversion factor";

//=============
// Variable Section

Real n(unit = "NA") "Efficiency of pump";

//=============
// Equation Section

equation
n = m * (p_f - p_i) * d / (P * c1 * c2);


end Ex10_1;