//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-10: Pumps, Compressors and Turbines
//Example: 10.2 Page 366
//Title: Positive  Displacement Pumps
//===================================================================

model Ex10_2

//=============
// Parameter Section

parameter Real p_max(unit = "psia")= 14.5 "Maximum pressure supplied by pump";
parameter Real p_min(unit = "psia") = 3.7 "Minimum pressure supplied by pump";
parameter Real h(unit = "m") = 4 "Height of the pipe";
parameter Real t(unit = "°F") = 150 "Temperature of the water";
parameter Real rho(unit = "lbm/ft3") = 61.3 "Density of water at the given temperature";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real v(unit = "ft/s") = 10 "Velocity of water in the pump";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real h_max(unit = "ft") "Maximum elevation of the pump inlet";

//=============
// Equation Section

equation
h_max = ((p_max - p_min) * c2 * c1 / (rho * g)) - (v^2 / (2 * g)) - h;
end Ex10_2;