//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-10: Pumps, Compressors and Turbines
//Example: 10.7 Page 381
//Title: Centrifugal Compressors
//===================================================================

model Ex10_7

//=============
// Parameter Section

parameter Real D(unit = "ft") = 2 "Diameter of the impeller";
parameter Real omega(unit = "1/s") = 1047 "Angular velocity of the impeller";
parameter Real rho(unit = "lbm/ft3") = 0.075 "Density of air";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real delp(unit = "psia") "Estimated pressure rise in the first stage";

//=============
// Equation Section

equation
delp = 0.5 * rho * (omega * D / 2)^2 / (c1 *c2);
end Ex10_7;