package Ex17_1

model Ex17_1_1

//=============
// Parameter Section

parameter Real x(unit = "ft") = 2 "Distance from the leading edge";
parameter Real V(unit = "mi/hr") = 200 "Velocity of the plane";
parameter Real v(unit = "ft2/s") = 1.6 * 10^(-4) "Kinematic viscosity of air";
parameter Real c1(unit = "s/h") = 3600 "Conversion factor";
parameter Real c2(unit = "ft/mi") = 5280 "Conversion factor";

//=============
// Variable Section

Real del(unit = "ft") "Boundary layer thickness";

//=============
// Equation Section

equation
del = 5 * (v * x / (V * c2 / c1))^0.5;

end Ex17_1_1;

model Ex17_1_2

//=============
// Parameter Section

parameter Real x(unit = "ft") = 2 "Distance from the leading edge";
parameter Real V(unit = "mi/hr") = 10 "Velocity of the ship";
parameter Real v(unit = "ft2/s") = 1.08 * 10^(-5) "Kinematic viscosity of water";
parameter Real c1(unit = "s/h") = 3600 "Conversion factor";
parameter Real c2(unit = "ft/mi") = 5280 "Conversion factor";

//=============
// Variable Section

Real del(unit = "ft") "Boundary layer thickness";

//=============
// Equation Section

equation
del = 5 * (v * x / (V * c2 / c1))^0.5;

end Ex17_1_2;
end Ex17_1;