//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-17: The Boundary Layer
//Example: 17.4 Page 530
//Title: Steady, Turbulent Boundary Layer on a flat plate
//===================================================================

model Ex17_4

//=============
// Parameter Section

parameter Real l(unit = "ft") = 20 "Length of the speedboat";
parameter Real b(unit = "ft") = 1 "Breadth of the speedboat";
parameter Real v(unit = "ft2/s") = 1.08 * 10^(-5) "Kinematic viscosity of the water";
parameter Real V(unit = "ft/s") = 50 "Speed of the boat";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real R(unit ="NA") "Reynolds number";
Real del(unit = "ft") "Boundary layer thickness";
Real F(unit = "lbf") "Drag on the plate";

//=============
// Equation Section

equation

R = V * l / v;
del = 0.37 * l / R^(1/5);
F = (0.072 / (R^(1/5))) * 0.5 * rho * V^2 * (2 * l * b) / c1;
end Ex17_4;