//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-19: Mixing
//Example: 19.6 Page 571
//Title: Mixing in Pipe Flow
//===================================================================

model Ex19_6

//=============
// Parameter Section
 
parameter Real D(unit = "ft") = 0.665 "Diameter of the pipe";
parameter Real V(unit = "ft/s") = 8 "Velocity of the fluid";
parameter Real f(unit = "NA") = 0.0039 "Friction factor";
parameter Real t(unit = "s") = 4.57 * 10^(5) "Time for the fluid travel";

//=============
// Variable Section

Real D_t(unit = "ft2/s") "Axial dispersion coefficient";
Real x(unit = "ft") "Distance from the initial interface";

//=============
// Equation Section

equation

D_t = 3.57 * V * D * (f)^0.5;
x = 2.15 * 2 * ( D_t * t )^0.5;
end Ex19_6;