//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.14 Page 56
//Title: Pressure Measurement
//===================================================================

model Ex2_14

//=============
// Parameter Section

parameter Real rho_w(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real s_w(unit = "NA") = 1 "Specific gravity of water";
parameter Real s_o(unit = "NA") = 1.1 "Specific gravity of oil";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real hw_1(unit = "ft") = 2 "Height of water in first manometer leg";
parameter Real hw_2(unit = "ft") = 1 "Height of water in second manometer leg";
parameter Real ho_1(unit = "ft") = 1 "Height of oil in first manometer leg";
parameter Real ho_2(unit = "ft") = 2 "Height of oil in second manometer leg";
parameter Real c1(unit  = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit  = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real delp(unit = "lbf/in2") "Pressure difference between two tanks";

//=============
// Equation Section

equation
delp = (rho_w * g *(hw_2 - hw_1) + (rho_w * s_o) * g * (ho_2 - ho_1)) / (c1 * c2);

end Ex2_14;