//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.16 Page 61
//Title: Manometer - Like Situations
//===================================================================

model Ex2_16

//=============
// Parameter Section

parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real z(unit = "ft") = 20 "Height of the percolator";
parameter Real rho_a(unit = "lbm/ft3") = 0.075 "Density of air";
parameter Real T_air(unit = "°R") = 528 "Temperature of air";
parameter Real T_flue(unit = "°R") = 760 "Temperature of flue gas";
parameter Real c1(unit  = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit  = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real delp(unit = "lbf/in2") "Pressure difference maintained";

//=============
// Equation Section

equation

delp = (g * z * rho_a * (1 - (T_air/T_flue))) / (c1 * c2);
end Ex2_16;