//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.3 Page 41
//Title: Pressure Depth Relations
//===================================================================

model Ex2_3

//=============
// Parameter Section

parameter Real rho(unit = "lbm/ft3") = 55 "Density of the the oil";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real d(unit = "ft") = 60 "depth of the tank";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real P_g(unit = "lbf/in2") "Gauge pressure at the given depth";

//=============
// Equation Section

equation
P_g = (rho * g * d / (c1 * c2));  

end Ex2_3;