//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.7 Page 45
//Title: Pressure Forces on Surfaces
//===================================================================

model Ex2_7

//=============
// Parameter Section

parameter Real D(unit = "ft") = 120 "Diameter of the tank";
parameter Real h(unit = "in") = 8 "Height of the water collected";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real c1(unit = "in/ft") = 12 "Conversion factor";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real P_g(unit = "lbf/ft2") "Gauge pressure";
Real F(unit = "lbf") "Force exerted by the water";

//=============
// Equation Section

equation
P_g = rho * g * (h/c1) / c2;
F = P_g * pi * (D)^2 / 4;
end Ex2_7;