//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.9 Page 49
//Title: Pressure Vessels and Piping
//===================================================================

model Ex2_9

//=============
// Parameter Section

parameter Real S_t(unit = "lbf/in2") = 20000 "Tensile stress";
parameter Real P(unit = "lbf/in2") = 22.9 "Gauge pressure";
parameter Real D(unit = "ft") = 120 "Diameter of the tank";

//=============
// Variable Section

Real t(unit = "ft") "Required thickness of the shell";

//=============
// Equation Section

equation
t = (P * D)/(2 * S_t);

end Ex2_9;