//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-3: The Balance Equation and the Mass Balance
//Example: 3.11 Page 97
//Title: Mass Balances for Mixtures
//===================================================================

model Ex3_11

//=============
// Parameter Section 

parameter Real q(unit = "kg/hr") = 5/8 "Mass flowrate of the paint";
parameter Real c(unit = "mg/m3") = 1.3 "Maximum concentration of benzene allowed";
parameter Real c1(unit = "mg/kg") = 10^6 "Conversion factor";

//=============
// Variable Section  

Real Q(unit = "m3/h") "Flow of ventilating air that must be supplied";

//=============
// Equation Section

equation
Q = q * c1 / c;
 
end Ex3_11;