//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.1 Page 111
//Title: Change in Potential Energy
//===================================================================

model Ex4_1

//=============
// Parameter Section 

parameter Real m(unit = "kg") = 10 "Mass given in kg";
parameter Real h(unit = "m") = 23 "Vertical distance given in meters";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";

//=============
// Variable Section 

Real PE(unit = "m2/s2") "Change in potential Energy per unit mass";
Real delPE(unit = "J") "Total change in Potential Energy";

//=============
// Equation Section 

equation
PE = g * h;
delPE = PE * m;

end Ex4_1;