//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.3 Page 112
//Title: Kinetic Energy of a Bullet
//===================================================================

model Ex4_3

//=============
// Parameter Section

parameter Real m(unit = "lbm") = 0.01 "Pound mass of the bullet";
parameter Real v1(unit = "ft/s") = 2000 "Velocity of the bullet";
parameter Real v2(unit = "ft/s") = 1990 "Velocity of the airplane";
parameter Real c(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real v(unit = "ft/s") "Relative velocity of the bullet with respect to the airplane";
Real KE(unit = "ft.lbf") "Kinetic energy of the bullet";

//=============
// Equation Section

equation
v = v1 - v2;
KE = m * v^2 / (2 * c);

end Ex4_3;